#!/bin/sh
set -e

DIR="$(cd "$(dirname "$0")" && pwd)"

if [ -f "$DIR/config.env" ]; then
  # shellcheck disable=SC1091
  . "$DIR/config.env"
fi

PORT="${PORT:-9090}"
BIND_ADDR="${BIND_ADDR:-0.0.0.0}"
ENABLE_UI="${ENABLE_UI:-true}"
TOKEN="${TOKEN:-}"

BASE_DIR="${BASE_DIR:-$DIR/server}"
DATA_DIR="$BASE_DIR/data"
RECORDINGS_DIR="${RECORDINGS_DIR:-$BASE_DIR/recordings}"

mkdir -p "$BASE_DIR" "$DATA_DIR" "$RECORDINGS_DIR"

exec "$DIR/iptvx-server"   --bind "$BIND_ADDR"   --port "$PORT"   --data "$DATA_DIR"   --recordings "$RECORDINGS_DIR"   --token "$TOKEN"   --ui "$ENABLE_UI"
